%-------------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      CreateAmplitudeSensor.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
%                 Professor Brian Wandell
%                 Professor Joyce Farrell
% Class:          PSYCH221
% File Version:   1
% Description:    This file defines a custom image sensor array
%-------------------------------------------------------------------------------

% Define the final (summed) gaussian
peak = 1.0;
wl_center = round((maxWavelength + minWavelength)/2);
width = (maxWavelength - minWavelength)/5;
finalGaussian = sensorColorFilter('gaussian', waveLengths, wl_center, width);
%figure(2);  plot(wave, finalGaussian); ylim([0 1]);

% Create the non-scaled gaussians
cPos = linspace(minWavelength,maxWavelength,numSensors+2);
cPos = cPos(2:end-1);
width = (ones(size(cPos))*(cPos(2)-cPos(1))/2);
filterSpectra = sensorColorFilter('gaussian', waveLengths, cPos, width);
%figure(2);  plot(wave, filterSpectra);

% Solve for the amplitudes necessary to reach the final gaussian
A = pinv(filterSpectra) * finalGaussian;

% Scale the filter spectra by this amount
for i = 1:numSensors,
   filterSpectra(:,i) = filterSpectra(:,i) * A(i);
   if (max(filterSpectra(:,i)) > 1.0),
      filterSpectra(:,i) = filterSpectra(:,i) ./ max(filterSpectra(:,i));
   end
end

% Verify the result
filterSpectraSum = sum(filterSpectra, 2);

% Plot the results
%{
figure(1);
%plot(wave, finalGaussian, 'r:');   hold on;
plot(wave, filterSpectraSum, 'k--');
hold on;
plot(wave, filterSpectra);
%}

% Build a default sensor
sensor = sensorCreate;
wave = sceneGet(scene,'wave');

% Use some subset of these names
allNames = {'b1','g1','r1','x1','i1','z1','i2'};
filterNames = cell(1,numSensors);
for ii=1:numSensors, 
   filterNames{ii} = allNames{ii};
end

% Show the wavelength partitioning
% figure(1); plot(wave,filterSpectra)

sensor = sensorSet(sensor,'wave',wave);
sensor = sensorSet(sensor,'filterSpectra',filterSpectra);
sensor = sensorSet(sensor,'filterNames',filterNames);


switch(numSensors),
   case{3}
      p = [3,2;2,1];
   case{4}
      p = [1,2;3,4];
   case{5}
      %p = [1,2,3; 2,3,4; 3,4,5];
      p = [2,2,2; 1,4,1; 3,3,5];
   case{6}
      %p = [1,3,4; 5,4,2; 4,3,6];
      %p = [1,4,1; 2,2,6; 3,3,5];
      p = [6,5,3;1,4,1;2,2,2];
   case{7}
      %p = [1,3,4; 2,4,6; 4,5,7];
      %p = [1,6,1; 7,3,5; 2,2,4];
      p = [1,4,1;2,5,2;3,6,7];
   otherwise
      p = [];
      while length(unique(p(:))) ~= numSensors
          p = round(rand(3,3)*(numSensors-1) + 1);
      end
      fprintf('Spatial pattern\n')
      p
end

sensor = sensorSet(sensor,'pattern',p);

%if (showISET == TRUE),
%   sensorShowCFA(sensor);
%end
sensorColorArray = zeros([size(p),3]);
for ii = 1:size(p,1),
   for jj = 1:size(p,2),
      [r,g,b] = WavelengthToRGB(cPos(p(ii,jj)));
      sensorColorArray(ii,jj,1) = r;
      sensorColorArray(ii,jj,2) = g;
      sensorColorArray(ii,jj,3) = b;
   end
end
figure();
sensorColorArray = imresize(sensorColorArray, [60,60], 'nearest');
imagesc(sensorColorArray, [0,1]);
axis image


% Match the sensor size to the scene FOV
sensor = sensorSetSizeToFOV(sensor,sceneGet(scene,'fov'));

% Compute the image and bring it up.
sensor = sensorCompute(sensor,oi);
vcAddAndSelectObject(sensor);

if (showISET == TRUE),
   sensorImageWindow;
end

% End of File
